/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlInventoryDetailItems;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Vector;

public class XmlInventoryItem {
    private String itemId;
    private String itemDescription;
    private String itemName;
    private String itemClass;
    private String itemSalesDescription;
    private BigDecimal itemSalesPrice1;
    private BigDecimal itemSalesPrice2;
    private BigDecimal itemSalesPrice3;
    private BigDecimal itemSalesPrice4;
    private BigDecimal itemSalesPrice5;
    private BigDecimal quantityOnHand;
    private String unitOfMeasure;
    private String itemType;
    private String itemGLSalesAccount;
    private String itemGLInventoryAccount;
    private String itemGLCOGSAccount;
    private BigDecimal lastUnitCost;
    private String itemTaxType;
    private String location;
    private boolean scale;
    private String productCategory;
    private String choiceGroup;
    private String vendor;
    private String vendorName;
    private boolean active;
    private boolean discountable;
    private boolean isGroup;
    private boolean isStock;
    private boolean isPrintGroupItems;
    private ArrayList inventoryDetailItems;
    private String manufacturerPartNumber;
    private String accountingRef;

    public XmlInventoryItem(String xmlString) {
        this.itemId = Utility.getElement("itemId", xmlString);
        this.itemDescription = Utility.getElement("ItemDescription", xmlString);
        this.itemName = Utility.getElement("itemName", xmlString);
        this.itemClass = Utility.getElement("itemClass", xmlString);
        this.itemSalesDescription = Utility.getElement("itemSalesDescription", xmlString);
        this.itemSalesPrice1 = new BigDecimal(Utility.getDoubleElement("itemSalesPrice1", xmlString), MathContext.DECIMAL64);
        this.itemSalesPrice2 = new BigDecimal(Utility.getDoubleElement("itemSalesPrice2", xmlString), MathContext.DECIMAL64);
        this.itemSalesPrice3 = new BigDecimal(Utility.getDoubleElement("itemSalesPrice3", xmlString), MathContext.DECIMAL64);
        this.itemSalesPrice4 = new BigDecimal(Utility.getDoubleElement("itemSalesPrice4", xmlString), MathContext.DECIMAL64);
        this.itemSalesPrice5 = new BigDecimal(Utility.getDoubleElement("itemSalesPrice5", xmlString), MathContext.DECIMAL64);
        this.quantityOnHand = new BigDecimal(Utility.getDoubleElement("quantityOnHand", xmlString), MathContext.DECIMAL64);
        this.unitOfMeasure = Utility.getElement("unitOfMeasure", xmlString);
        this.itemType = Utility.getElement("itemType", xmlString);
        this.itemGLSalesAccount = Utility.getElement("itemGLSalesAccount", xmlString);
        this.itemGLInventoryAccount = Utility.getElement("itemGLInventoryAccount", xmlString);
        this.itemGLCOGSAccount = Utility.getElement("itemGLCOGSAccount", xmlString);
        this.lastUnitCost = new BigDecimal(Utility.getDoubleElement("lastUnitCost", xmlString), MathContext.DECIMAL64);
        this.itemTaxType = Utility.getElement("itemTaxType", xmlString);
        this.location = Utility.getElement("location", xmlString);
        this.scale = Utility.getBooleanElement("scale", xmlString);
        this.productCategory = Utility.getElement("productCategory", xmlString);
        this.choiceGroup = Utility.getElement("choiceGroup", xmlString);
        this.vendor = Utility.getElement("vendor", xmlString);
        this.vendorName = Utility.getElement("vendorName", xmlString);
        this.active = Utility.getBooleanElement("active", xmlString);
        this.discountable = Utility.getBooleanElement("discountable", xmlString);
        this.isGroup = Utility.getBooleanElement("isGroup", xmlString);
        this.isStock = Utility.getBooleanElement("isStock", xmlString);
        this.isPrintGroupItems = Utility.getBooleanElement("isPrintGroupItems", xmlString);
        this.manufacturerPartNumber = Utility.getElement("manufacturerPartNumber", xmlString);
        this.accountingRef = Utility.getElement("accountingRef", xmlString);
        Vector InventoryDetailItemStrings = Utility.getElementList("detailItems", xmlString);
        ArrayList<XmlInventoryDetailItems> parsedInventoryDetailItems = new ArrayList<XmlInventoryDetailItems>();
        int numInventoryDetailItems = 0;
        if (InventoryDetailItemStrings != null && !InventoryDetailItemStrings.isEmpty()) {
            numInventoryDetailItems = InventoryDetailItemStrings.size();
        }
        for (int i = 0; i < numInventoryDetailItems; ++i) {
            String thisInventoryDetailItemXml = (String)InventoryDetailItemStrings.get(i);
            XmlInventoryDetailItems thisInventoryDetailItem = new XmlInventoryDetailItems(thisInventoryDetailItemXml);
            parsedInventoryDetailItems.add(thisInventoryDetailItem);
        }
        this.inventoryDetailItems = parsedInventoryDetailItems;
    }

    public XmlInventoryItem() {
        this.inventoryDetailItems = new ArrayList();
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<item>");
        xml.append("<itemId>" + this.itemId + "</itemId>");
        xml.append("<ItemDescription>" + this.itemDescription + "</ItemDescription>");
        xml.append("<itemName>" + this.itemName + "</itemName>");
        xml.append("<itemClass>" + this.itemClass + "</itemClass>");
        xml.append("<itemSalesDescription>" + this.itemSalesDescription + "</itemSalesDescription>");
        xml.append("<itemSalesPrice1>" + this.itemSalesPrice1 + "</itemSalesPrice1>");
        xml.append("<itemSalesPrice2>" + this.itemSalesPrice2 + "</itemSalesPrice2>");
        xml.append("<itemSalesPrice3>" + this.itemSalesPrice3 + "</itemSalesPrice3>");
        xml.append("<itemSalesPrice4>" + this.itemSalesPrice4 + "</itemSalesPrice4>");
        xml.append("<itemSalesPrice5>" + this.itemSalesPrice5 + "</itemSalesPrice5>");
        xml.append("<quantityOnHand>" + this.quantityOnHand + "</quantityOnHand>");
        xml.append("<unitOfMeasure>" + this.unitOfMeasure + "</unitOfMeasure>");
        xml.append("<itemType>" + this.itemType + "</itemType>");
        xml.append("<itemGLSalesAccount>" + this.itemGLSalesAccount + "</itemGLSalesAccount>");
        xml.append("<itemGLInventoryAccount>" + this.itemGLInventoryAccount + "</itemGLInventoryAccount>");
        xml.append("<itemGLCOGSAccount>" + this.itemGLCOGSAccount + "</itemGLCOGSAccount>");
        xml.append("<lastUnitCost>" + this.lastUnitCost + "</lastUnitCost>");
        xml.append("<itemTaxType>" + this.itemTaxType + "</itemTaxType>");
        xml.append("<location>" + this.location + "</location>");
        xml.append("<scale>" + this.scale + "</scale>");
        xml.append("<productCategory>" + this.productCategory + "</productCategory>");
        xml.append("<choiceGroup>" + this.choiceGroup + "</choiceGroup>");
        xml.append("<vendor>" + this.vendor + "</vendor>");
        xml.append("<vendorName>" + this.vendorName + "</vendorName>");
        xml.append("<active>" + this.active + "</active>");
        xml.append("<discountable>" + this.discountable + "</discountable>");
        xml.append("<isGroup>" + this.isGroup + "</isGroup>");
        xml.append("<isStock>" + this.isStock + "</isStock>");
        xml.append("<isPrintGroupItems>" + this.isPrintGroupItems + "</isPrintGroupItems>");
        xml.append("<manufacturerPartNumber>" + this.manufacturerPartNumber + "</manufacturerPartNumber>");
        xml.append("<accountingRef>" + this.accountingRef + "</accountingRef>");
        if (this.inventoryDetailItems != null) {
            int numItems = 0;
            if (this.inventoryDetailItems != null && !this.inventoryDetailItems.isEmpty()) {
                numItems = this.inventoryDetailItems.size();
            }
            for (int i = 0; i < numItems; ++i) {
                XmlInventoryDetailItems inventoryDetailItem = (XmlInventoryDetailItems)this.inventoryDetailItems.get(i);
                xml.append(inventoryDetailItem.toXml());
            }
        }
        xml.append("</item>");
        return xml.toString();
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
    }

    public void setItemSalesDescription(String itemSalesDescription) {
        this.itemSalesDescription = itemSalesDescription;
    }

    public void setItemSalesPrice1(BigDecimal itemSalesPrice1) {
        this.itemSalesPrice1 = itemSalesPrice1;
    }

    public void setItemSalesPrice2(BigDecimal itemSalesPrice2) {
        this.itemSalesPrice2 = itemSalesPrice2;
    }

    public void setItemSalesPrice3(BigDecimal itemSalesPrice3) {
        this.itemSalesPrice3 = itemSalesPrice3;
    }

    public void setItemSalesPrice4(BigDecimal itemSalesPrice4) {
        this.itemSalesPrice4 = itemSalesPrice4;
    }

    public void setItemSalesPrice5(BigDecimal itemSalesPrice5) {
        this.itemSalesPrice5 = itemSalesPrice5;
    }

    public void setQuantityOnHand(BigDecimal quantityOnHand) {
        this.quantityOnHand = quantityOnHand;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setItemGLSalesAccount(String itemGLSalesAccount) {
        this.itemGLSalesAccount = itemGLSalesAccount;
    }

    public void setItemGLInventoryAccount(String itemGLInventoryAccount) {
        this.itemGLInventoryAccount = itemGLInventoryAccount;
    }

    public void setItemGLCOGSAccount(String itemGLCOGSAccount) {
        this.itemGLCOGSAccount = itemGLCOGSAccount;
    }

    public void setLastUnitCost(BigDecimal lastUnitCost) {
        this.lastUnitCost = lastUnitCost;
    }

    public void setItemTaxType(String itemTaxType) {
        this.itemTaxType = itemTaxType;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setScale(boolean scale) {
        this.scale = scale;
    }

    public void setProductCategory(String productCategory) {
        this.productCategory = productCategory;
    }

    public void setChoiceGroup(String choiceGroup) {
        this.choiceGroup = choiceGroup;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDiscountable(boolean discountable) {
        this.discountable = discountable;
    }

    public void setIsGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public void setIsStock(boolean isStock) {
        this.isStock = isStock;
    }

    public void setIsPrintGroupItems(boolean isPrintGroupItems) {
        this.isPrintGroupItems = isPrintGroupItems;
    }

    public void setInventoryDetailItems(ArrayList inventoryDetailItems) {
        this.inventoryDetailItems = inventoryDetailItems;
    }

    public void setmanufacturerPartNumber(String manufacturerPartNumber) {
        this.manufacturerPartNumber = manufacturerPartNumber;
    }

    public void setAccountingRef(String accountingRef) {
        this.accountingRef = accountingRef;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public String getItemSalesDescription() {
        return this.itemSalesDescription;
    }

    public BigDecimal getItemSalesPrice1() {
        return this.itemSalesPrice1;
    }

    public BigDecimal getItemSalesPrice2() {
        return this.itemSalesPrice2;
    }

    public BigDecimal getItemSalesPrice3() {
        return this.itemSalesPrice3;
    }

    public BigDecimal getItemSalesPrice4() {
        return this.itemSalesPrice4;
    }

    public BigDecimal getItemSalesPrice5() {
        return this.itemSalesPrice5;
    }

    public BigDecimal getQuantityOnHand() {
        return this.quantityOnHand;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getItemGLSalesAccount() {
        return this.itemGLSalesAccount;
    }

    public String getItemGLInventoryAccount() {
        return this.itemGLInventoryAccount;
    }

    public String getItemGLCOGSAccount() {
        return this.itemGLCOGSAccount;
    }

    public BigDecimal getLastUnitCost() {
        return this.lastUnitCost;
    }

    public String getItemTaxType() {
        return this.itemTaxType;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isScale() {
        return this.scale;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public String getChoiceGroup() {
        return this.choiceGroup;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isDiscountable() {
        return this.discountable;
    }

    public boolean isIsGroup() {
        return this.isGroup;
    }

    public boolean isIsStock() {
        return this.isStock;
    }

    public boolean isIsPrintGroupItems() {
        return this.isPrintGroupItems;
    }

    public ArrayList getInventoryDetailItems() {
        return this.inventoryDetailItems;
    }

    public String getManufacturerPartNumber() {
        return this.manufacturerPartNumber;
    }

    public String getAccountingRef() {
        return this.accountingRef;
    }
}

