/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlCustomer;
import IntegratorDataObjects.XmlLineItem;
import IntegratorDataObjects.XmlTax;
import IntegratorDataObjects.XmlTendering;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class XmlInvoice {
    private long transactionNumber = 0L;
    private Timestamp dateEntered = null;
    private Timestamp dateInvoiced = null;
    private boolean creditMemo = false;
    private long invoiceNumber = 0L;
    private String zTill = "";
    private int zSequence = 0;
    private ArrayList lineItems = new ArrayList();
    private XmlTendering tendering = new XmlTendering();
    private ArrayList taxes = new ArrayList();
    private Timestamp dateDue = null;
    private Timestamp discountDue = null;
    private XmlCustomer customer = null;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public XmlInvoice(long transactionNumber, Timestamp dateEntered, Timestamp dateInvoiced, boolean creditMemo, long invoiceNumber, String zTill, int zSequence, ArrayList<XmlLineItem> lineItems, XmlTendering tendering, ArrayList<XmlTax> taxes, Timestamp dateDue, Timestamp discountDue, XmlCustomer customer) {
        this.transactionNumber = transactionNumber;
        this.dateEntered = dateEntered;
        this.dateInvoiced = dateInvoiced;
        this.creditMemo = creditMemo;
        this.invoiceNumber = invoiceNumber;
        this.zTill = zTill;
        this.zSequence = zSequence;
        this.lineItems = lineItems;
        this.tendering = tendering;
        this.taxes = taxes;
        this.dateDue = dateDue;
        this.discountDue = discountDue;
        this.customer = customer;
    }

    public XmlInvoice(String xmlString) {
        Date date;
        this.transactionNumber = Utility.getLongElement("transactionNumber", xmlString);
        try {
            date = this.dateFormat.parse(Utility.getElement("dateEntered", xmlString));
            this.dateEntered = new Timestamp(date.getTime());
        }
        catch (ParseException ex) {
            this.dateEntered = null;
        }
        try {
            date = this.dateFormat.parse(Utility.getElement("dateInvoiced", xmlString));
            this.dateInvoiced = new Timestamp(date.getTime());
        }
        catch (ParseException ex) {
            this.dateInvoiced = null;
        }
        try {
            date = this.dateFormat.parse(Utility.getElement("dateDue", xmlString));
            this.dateDue = new Timestamp(date.getTime());
        }
        catch (ParseException ex) {
            this.dateDue = null;
        }
        try {
            date = this.dateFormat.parse(Utility.getElement("discountDue", xmlString));
            this.discountDue = new Timestamp(date.getTime());
        }
        catch (ParseException ex) {
            this.discountDue = null;
        }
        this.invoiceNumber = Utility.getLongElement("invoiceNumber", xmlString);
        this.zTill = Utility.getElement("zTill", xmlString);
        this.zSequence = Utility.getIntElement("zSequence", xmlString);
        String lineItemsXml = Utility.getElement("lineItems", xmlString);
        Vector lineItemsStrings = Utility.getElementList("lineItem", lineItemsXml);
        ArrayList<XmlLineItem> lineItemsList = new ArrayList<XmlLineItem>();
        int numLineItems = 0;
        if (lineItemsStrings != null && !lineItemsStrings.isEmpty()) {
            numLineItems = lineItemsStrings.size();
        }
        for (int i = 0; i < numLineItems; ++i) {
            String thisLineItemXml = (String)lineItemsStrings.get(i);
            XmlLineItem thisInvoice = new XmlLineItem(thisLineItemXml);
            lineItemsList.add(thisInvoice);
        }
        this.lineItems = lineItemsList;
        this.tendering = new XmlTendering(Utility.getElement("tendering", xmlString));
        String taxesXml = Utility.getElement("taxes", xmlString);
        Vector taxStrings = this.extractParentTaxElements(taxesXml);
        ArrayList<XmlTax> taxesList = new ArrayList<XmlTax>();
        int numTaxes = 0;
        if (taxStrings != null && !taxStrings.isEmpty()) {
            numTaxes = taxStrings.size();
        }
        for (int i = 0; i < numTaxes; ++i) {
            String thisTaxXml = (String)taxStrings.get(i);
            XmlTax thisTax = new XmlTax(thisTaxXml);
            taxesList.add(thisTax);
        }
        this.taxes = taxesList;
        String customerXml = Utility.getElement("customer", xmlString);
        if (!customerXml.isEmpty()) {
            this.customer = new XmlCustomer(customerXml);
        }
        this.creditMemo = Utility.getBooleanElement("creditMemo", xmlString);
    }

    private Vector extractParentTaxElements(String xmlContent) {
        Vector<String> parentTaxElements = new Vector<String>();
        int startIndex = 0;
        while (startIndex != -1) {
            if ((startIndex = xmlContent.indexOf("<tax>", startIndex)) == -1) continue;
            int endIndex = this.findMatchingEndTag(xmlContent, startIndex, "tax");
            if (endIndex != -1) {
                String taxElement = xmlContent.substring(startIndex + 5, endIndex);
                if (taxElement.indexOf("<tax>", 5) != -1) {
                    parentTaxElements.add(taxElement);
                }
                startIndex = endIndex + 6;
                continue;
            }
            startIndex = -1;
        }
        return parentTaxElements;
    }

    private int findMatchingEndTag(String xml, int startIndex, String tagName) {
        int openTagCount = 1;
        int currentIndex = startIndex + tagName.length() + 2;
        while (openTagCount > 0 && currentIndex < xml.length()) {
            int nextOpenTag = xml.indexOf("<" + tagName + ">", currentIndex);
            int nextCloseTag = xml.indexOf("</" + tagName + ">", currentIndex);
            if (nextCloseTag != -1 && (nextOpenTag == -1 || nextCloseTag < nextOpenTag)) {
                --openTagCount;
                currentIndex = nextCloseTag + tagName.length() + 3;
                continue;
            }
            if (nextOpenTag != -1) {
                ++openTagCount;
                currentIndex = nextOpenTag + tagName.length() + 2;
                continue;
            }
            return -1;
        }
        return openTagCount == 0 ? currentIndex - tagName.length() - 3 : -1;
    }

    public XmlInvoice() {
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean legacySupport) {
        StringBuilder xml = new StringBuilder();
        xml.append("  <invoice>\r\n");
        xml.append("    <transactionNumber>" + this.transactionNumber + "</transactionNumber>" + "\r\n");
        if (this.dateEntered != null) {
            xml.append("    <dateEntered>" + this.dateFormat.format(this.dateEntered) + "</dateEntered>" + "\r\n");
        }
        if (this.dateInvoiced != null) {
            xml.append("    <dateInvoiced>" + this.dateFormat.format(this.dateInvoiced) + "</dateInvoiced>" + "\r\n");
        }
        if (this.dateDue != null) {
            xml.append("    <dateDue>" + this.dateFormat.format(this.dateDue) + "</dateDue>" + "\r\n");
        }
        if (this.discountDue != null) {
            xml.append("    <discountDue>" + this.dateFormat.format(this.discountDue) + "</discountDue>" + "\r\n");
        }
        xml.append("    <creditMemo>" + this.creditMemo + "</creditMemo>" + "\r\n");
        xml.append("    <invoiceNumber>" + this.invoiceNumber + "</invoiceNumber>" + "\r\n");
        xml.append("    <zTill>" + this.zTill + "</zTill>" + "\r\n");
        xml.append("    <zSequence>" + this.zSequence + "</zSequence>" + "\r\n");
        if (this.customer != null) {
            xml.append(this.customer.toXml(legacySupport));
        }
        xml.append("    <lineItems>\r\n");
        int numLineItems = 0;
        if (this.lineItems != null && !this.lineItems.isEmpty()) {
            numLineItems = this.lineItems.size();
        }
        for (int i = 0; i < numLineItems; ++i) {
            XmlLineItem thisLineItem = (XmlLineItem)this.lineItems.get(i);
            xml.append(thisLineItem.toXml(legacySupport));
        }
        xml.append("    </lineItems>\r\n");
        xml.append(this.tendering.toXml());
        xml.append("    <taxes>\r\n");
        int numTaxes = 0;
        if (this.taxes != null && !this.taxes.isEmpty()) {
            numTaxes = this.taxes.size();
        }
        for (int i = 0; i < numTaxes; ++i) {
            XmlTax thisTax = (XmlTax)this.taxes.get(i);
            xml.append(thisTax.toXml());
        }
        xml.append("    </taxes>\r\n");
        xml.append("  </invoice>\r\n");
        return xml.toString();
    }

    public void setTransactionNumber(long transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public void setDateEntered(Timestamp dateEntered) {
        this.dateEntered = dateEntered;
    }

    public void setDateInvoiced(Timestamp dateInvoiced) {
        this.dateInvoiced = dateInvoiced;
    }

    public void setCreditMemo(boolean creditMemo) {
        this.creditMemo = creditMemo;
    }

    public void setInvoiceNumber(long invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public void setZTill(String zTill) {
        this.zTill = zTill;
    }

    public void setZSequence(int zSequence) {
        this.zSequence = zSequence;
    }

    public void setLineItems(ArrayList lineItems) {
        this.lineItems = lineItems;
    }

    public void setTendering(XmlTendering tendering) {
        this.tendering = tendering;
    }

    public void setTaxes(ArrayList taxes) {
        this.taxes = taxes;
    }

    public void setDateDue(Timestamp dateDue) {
        this.dateDue = dateDue;
    }

    public void setDiscountDue(Timestamp discountDue) {
        this.discountDue = discountDue;
    }

    public void setCustomer(XmlCustomer customer) {
        this.customer = customer;
    }

    public ArrayList getLineItems() {
        return this.lineItems;
    }

    public long getTransactionNumber() {
        return this.transactionNumber;
    }

    public Timestamp getDateEntered() {
        return this.dateEntered;
    }

    public Timestamp getDateInvoicedTimestamp() {
        return this.dateInvoiced;
    }

    public GregorianCalendar getDateInvoiced() {
        GregorianCalendar date = new GregorianCalendar();
        date.setTimeInMillis(this.dateInvoiced.getTime());
        return date;
    }

    public boolean isCreditMemo() {
        return this.creditMemo;
    }

    public long getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getZTill() {
        return this.zTill;
    }

    public int getZSequence() {
        return this.zSequence;
    }

    public XmlTendering getTendering() {
        return this.tendering;
    }

    public ArrayList getTaxes() {
        return this.taxes;
    }

    public Timestamp getDateDue() {
        return this.dateDue;
    }

    public Timestamp getDiscountDue() {
        return this.discountDue;
    }

    public XmlCustomer getCustomer() {
        return this.customer;
    }
}

