/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlTender;
import java.util.ArrayList;
import java.util.Vector;

public class XmlTendering {
    private boolean cashSale = false;
    private ArrayList tenders = new ArrayList();

    public XmlTendering(boolean cashSale, ArrayList<XmlTender> tenders) {
        this.cashSale = cashSale;
        this.tenders = tenders;
    }

    public XmlTendering(String xmlString) {
        this.cashSale = Utility.getBooleanElement("cashSale", xmlString);
        Vector tenderStrings = Utility.getElementList("tender", xmlString);
        ArrayList<XmlTender> tendersList = new ArrayList<XmlTender>();
        int numTenders = 0;
        if (tenderStrings != null && !tenderStrings.isEmpty()) {
            numTenders = tenderStrings.size();
        }
        for (int i = 0; i < numTenders; ++i) {
            String thisTenderXml = (String)tenderStrings.get(i);
            XmlTender thisTender = new XmlTender(thisTenderXml);
            tendersList.add(thisTender);
        }
        this.tenders = tendersList;
    }

    public XmlTendering() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("      <tendering>\r\n");
        xml.append("        <cashSale>" + this.cashSale + "</cashSale>" + "\r\n");
        int numTenders = 0;
        if (this.tenders != null && !this.tenders.isEmpty()) {
            numTenders = this.tenders.size();
        }
        for (int i = 0; i < numTenders; ++i) {
            XmlTender thisTender = (XmlTender)this.tenders.get(i);
            xml.append(thisTender.toXml());
        }
        xml.append("        </tendering>\r\n");
        return xml.toString();
    }

    public void setCashSale(boolean cashSale) {
        this.cashSale = cashSale;
    }

    public void setTenders(ArrayList tenders) {
        this.tenders = tenders;
    }

    public ArrayList getTenders() {
        return this.tenders;
    }

    public boolean isCashSale() {
        return this.cashSale;
    }
}

