/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class BarCodeInfo {
    public String prefix = "";
    public int itemStart = 0;
    public int itemLength = 0;
    public int priceStart = 0;
    public int priceLength = 0;
    public int priceDivisor = 0;
    public int weightStart = 0;
    public int weightLength = 0;
    public int weightDivisor = 0;

    public BarCodeInfo(String prefix, int itemStart, int itemLength, int priceStart, int priceLength, int priceDivisor, int weightStart, int weightLength, int weightDivisor) {
        this.prefix = prefix;
        this.itemStart = itemStart;
        this.itemLength = itemLength;
        this.priceStart = priceStart;
        this.priceLength = priceLength;
        this.priceDivisor = priceDivisor;
        this.weightStart = weightStart;
        this.weightLength = weightLength;
        this.weightDivisor = weightDivisor;
    }

    public BarCodeInfo(String xml) {
        this.prefix = Utility.getElement("Prefix", xml);
        this.itemStart = Utility.getIntElement("ItemStart", xml);
        this.itemLength = Utility.getIntElement("ItemLength", xml);
        this.priceStart = Utility.getIntElement("PriceStart", xml);
        this.priceLength = Utility.getIntElement("PriceLength", xml);
        this.priceDivisor = Utility.getIntElement("PriceDivisor", xml);
        this.weightStart = Utility.getIntElement("WeightStart", xml);
        this.weightLength = Utility.getIntElement("WeightLength", xml);
        this.weightDivisor = Utility.getIntElement("WeightDivisor", xml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<BarCodeSetup>");
        xml.append("<Prefix>" + this.prefix + "</Prefix>");
        xml.append("<ItemStart>" + this.itemStart + "</ItemStart>");
        xml.append("<ItemLength>" + this.itemLength + "</ItemLength>");
        xml.append("<PriceStart>" + this.priceStart + "</PriceStart>");
        xml.append("<PriceLength>" + this.priceLength + "</PriceLength>");
        xml.append("<PriceDivisor>" + this.priceDivisor + "</PriceDivisor>");
        xml.append("<WeightStart>" + this.weightStart + "</WeightStart>");
        xml.append("<WeightLength>" + this.weightLength + "</WeightLength>");
        xml.append("<WeightDivisor>" + this.weightDivisor + "</WeightDivisor>");
        xml.append("</BarCodeSetup>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject deliScaleInfo = new JSONObject();
        try {
            deliScaleInfo.put("prefix", (Object)this.prefix);
            deliScaleInfo.put("itemStart", this.itemStart);
            deliScaleInfo.put("itemLength", this.itemLength);
            deliScaleInfo.put("priceStart", this.priceStart);
            deliScaleInfo.put("priceLength", this.priceLength);
            deliScaleInfo.put("priceDivisor", this.priceDivisor);
            deliScaleInfo.put("weightStart", this.weightStart);
            deliScaleInfo.put("weightLength", this.weightLength);
            deliScaleInfo.put("weightDivisor", this.weightDivisor);
            jsonObject.put("deliScaleInfo", (Object)deliScaleInfo);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public BarCodeInfo(JSONString jsonString) {
        this.prefix = Utility.getJSONString(jsonString.toString(), "prefix");
        this.itemStart = Utility.getJSONInt(jsonString.toString(), "itemStart");
        this.itemLength = Utility.getJSONInt(jsonString.toString(), "itemLength");
        this.priceStart = Utility.getJSONInt(jsonString.toString(), "priceStart");
        this.priceLength = Utility.getJSONInt(jsonString.toString(), "priceLength");
        this.priceDivisor = Utility.getJSONInt(jsonString.toString(), "priceDivisor");
        this.weightStart = Utility.getJSONInt(jsonString.toString(), "weightStart");
        this.weightLength = Utility.getJSONInt(jsonString.toString(), "weightLength");
        this.weightDivisor = Utility.getJSONInt(jsonString.toString(), "weightDivisor");
    }
}

