/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.DecimalFormat;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class Customer {
    public boolean isActive = true;
    public String code = "";
    public String companyName = "";
    public String first = "";
    public String middle = "";
    public String last = "";
    public String address1 = "";
    public String address2 = "";
    public String city = "";
    public String state = "";
    public String zip = "";
    public String country = "";
    public String contact = "";
    public boolean taxable = false;
    public String email = "";
    public String phone = "";
    public String fax = "";
    public String terms = "";
    public String type = "";
    public int priceLevel = 0;
    public double creditLimit = 0.0;
    public double balance = 0.0;
    public double loyaltyBalance = 0.0;
    public String discountItemId = "";
    public double discountPercent = 0.0;
    public String taxCode = "";
    public String note = "";
    public String deliveryNotes = "";
    public boolean updated = false;
    public int dueDays = 0;
    public int discountDays = 0;
    public boolean uploaded = false;
    public boolean isComoCustomer = false;
    public String accountingRef = "";
    public String resaleNo = "";
    public String extendedData = "";
    public String networkId = "";

    public Customer() {
    }

    public Customer(String xml) {
        this.isActive = Utility.getBooleanElement("IsActive", xml);
        this.code = Utility.getElement("CustomerCode", xml);
        this.companyName = Utility.getElement("CompanyName", xml);
        this.first = Utility.getElement("First", xml);
        this.middle = Utility.getElement("Middle", xml);
        this.last = Utility.getElement("Last", xml);
        this.address1 = Utility.getElement("Address1", xml);
        this.address2 = Utility.getElement("Address2", xml);
        this.city = Utility.getElement("City", xml);
        this.state = Utility.getElement("State", xml);
        this.zip = Utility.getElement("Zip", xml);
        this.country = Utility.getElement("Country", xml);
        this.contact = Utility.getElement("Contact", xml);
        this.taxable = Utility.getBooleanElement("CustomerTaxable", xml);
        this.email = Utility.getElement("Email", xml);
        if (this.email == null) {
            this.email = "";
        }
        this.phone = Utility.getElement("Phone", xml);
        this.fax = Utility.getElement("Fax", xml);
        this.terms = Utility.getElement("Terms", xml);
        this.type = Utility.getElement("CustomerType", xml);
        this.priceLevel = Utility.getIntElement("PriceLevel", xml);
        this.creditLimit = Utility.getDoubleElement("CreditLimit", xml);
        this.balance = Utility.getDoubleElement("CustomerBalance", xml);
        this.loyaltyBalance = Utility.getDoubleElement("LoyaltyBalance", xml);
        this.discountItemId = Utility.getElement("DiscountItemId", xml);
        this.discountPercent = Utility.getDoubleElement("CustomerDiscountPercent", xml);
        this.taxCode = Utility.getElement("CustomerTaxCode", xml);
        this.note = Utility.getElement("Note", xml);
        this.deliveryNotes = Utility.getElement("DeliveryNotes", xml);
        this.dueDays = Utility.getIntElement("DueDays", xml);
        this.discountDays = Utility.getIntElement("DiscountDays", xml);
        this.uploaded = Utility.getBooleanElement("Uploaded", xml);
        this.isComoCustomer = Utility.getBooleanElement("IsComoCustomer", xml);
        this.accountingRef = Utility.getElement("AccountingRef", xml);
        this.resaleNo = Utility.getElement("ResaleNo", xml);
        this.extendedData = Utility.getElement("ExtendedData", xml);
        this.networkId = Utility.getElement("NetworkId", xml);
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.####;-####0.####");
        StringBuffer xml = new StringBuffer();
        xml.append("<Customer>");
        xml.append("<IsActive>" + this.isActive + "</IsActive>");
        xml.append("<CustomerCode>" + this.code + "</CustomerCode>");
        xml.append("<CompanyName>" + this.companyName + "</CompanyName>");
        xml.append("<First>" + this.first + "</First>");
        xml.append("<Middle>" + this.middle + "</Middle>");
        xml.append("<Last>" + this.last + "</Last>");
        xml.append("<Address1>" + this.address1 + "</Address1>");
        xml.append("<Address2>" + this.address2 + "</Address2>");
        xml.append("<City>" + this.city + "</City>");
        xml.append("<State>" + this.state + "</State>");
        xml.append("<Zip>" + this.zip + "</Zip>");
        xml.append("<Country>" + this.country + "</Country>");
        xml.append("<Contact>" + this.contact + "</Contact>");
        xml.append("<CustomerTaxable>" + this.taxable + "</CustomerTaxable>");
        if (this.email == null) {
            this.email = "";
        }
        xml.append("<Email>" + this.email + "</Email>");
        xml.append("<Phone>" + this.phone + "</Phone>");
        xml.append("<Fax>" + this.fax + "</Fax>");
        xml.append("<Terms>" + this.terms + "</Terms>");
        xml.append("<CustomerType>" + this.type + "</CustomerType>");
        xml.append("<PriceLevel>" + this.priceLevel + "</PriceLevel>");
        xml.append("<CreditLimit>" + this.creditLimit + "</CreditLimit>");
        xml.append("<CustomerBalance>" + decimal.format(this.balance) + "</CustomerBalance>");
        xml.append("<LoyaltyBalance>" + this.loyaltyBalance + "</LoyaltyBalance>");
        xml.append("<DiscountItemId>" + this.discountItemId + "</DiscountItemId>");
        xml.append("<CustomerDiscountPercent>" + this.discountPercent + "</CustomerDiscountPercent>");
        xml.append("<CustomerTaxCode>" + this.taxCode + "</CustomerTaxCode>");
        xml.append("<Note>" + this.note + "</Note>");
        xml.append("<DeliveryNotes>" + this.deliveryNotes + "</DeliveryNotes>");
        xml.append("<DueDays>" + this.dueDays + "</DueDays>");
        xml.append("<DiscountDays>" + this.discountDays + "</DiscountDays>");
        xml.append("<Uploaded>" + this.uploaded + "</Uploaded>");
        xml.append("<IsComoCustomer>" + this.isComoCustomer + "</IsComoCustomer>");
        xml.append("<AccountingRef>" + this.accountingRef + "</AccountingRef>");
        xml.append("<ResaleNo>" + this.resaleNo + "</ResaleNo>");
        xml.append("<ExtendedData>" + this.extendedData + "</ExtendedData>");
        xml.append("<NetworkId>" + this.networkId + "</NetworkId>");
        xml.append("</Customer>");
        return xml.toString();
    }

    public boolean isSame(Object obj) {
        boolean result = false;
        if (obj == null || obj.getClass() != this.getClass()) {
            return result;
        }
        result = this.code.equals(((Customer)obj).code) && this.companyName.equals(((Customer)obj).companyName) && this.middle.equals(((Customer)obj).middle) && this.last.equals(((Customer)obj).last) && this.address1.equals(((Customer)obj).address1) && this.address2.equals(((Customer)obj).address2) && this.city.equals(((Customer)obj).city) && this.state.equals(((Customer)obj).state) && this.zip.equals(((Customer)obj).zip) && this.contact.equals(((Customer)obj).contact) && this.taxable == ((Customer)obj).taxable && this.email.equals(((Customer)obj).email) && this.phone.equals(((Customer)obj).phone) && this.fax.equals(((Customer)obj).fax) && this.type.equals(((Customer)obj).type) && this.priceLevel == ((Customer)obj).priceLevel && this.creditLimit == ((Customer)obj).creditLimit && this.note.equals(((Customer)obj).note) && this.deliveryNotes.equals(((Customer)obj).deliveryNotes);
        return result;
    }

    public Customer(JSONString jsonString) {
        String customerJson = jsonString.toString();
        this.code = Utility.getJSONString(customerJson, "id");
        this.code = Utility.translateSpecial(this.code);
        this.companyName = Utility.getJSONString(jsonString.toString(), "companyName");
        this.first = Utility.getJSONString(customerJson, "first");
        this.middle = Utility.getJSONString(customerJson, "middle");
        this.last = Utility.getJSONString(customerJson, "last");
        this.address1 = Utility.getJSONString(customerJson, "address1");
        this.address2 = Utility.getJSONString(customerJson, "address2");
        this.city = Utility.getJSONString(customerJson, "city");
        this.state = Utility.getJSONString(customerJson, "state");
        this.zip = Utility.getJSONString(customerJson, "zip");
        this.country = Utility.getJSONString(customerJson, "country");
        this.contact = Utility.getJSONString(customerJson, "contact");
        this.taxable = Utility.getJSONBoolean(customerJson, "taxable");
        if (this.email == null) {
            this.email = "";
        }
        this.email = Utility.getJSONString(customerJson, "email");
        this.phone = Utility.getJSONString(customerJson, "phone");
        this.fax = Utility.getJSONString(customerJson, "fax");
        this.terms = Utility.getJSONString(customerJson, "terms");
        this.type = Utility.getJSONString(customerJson, "type");
        this.priceLevel = Utility.getJSONInt(customerJson, "priceLevel");
        this.creditLimit = Utility.getJSONDouble(customerJson, "creditLimit");
        this.balance = Utility.getJSONDouble(customerJson, "balance");
        this.loyaltyBalance = Utility.getJSONDouble(customerJson, "loyaltyBalance");
        this.discountItemId = Utility.getJSONString(customerJson, "discountItemId");
        this.discountPercent = Utility.getJSONDouble(customerJson, "discount");
        this.taxCode = Utility.getJSONString(customerJson, "taxCode");
        this.note = Utility.getJSONString(customerJson, "notes");
        this.deliveryNotes = Utility.getJSONString(customerJson, "deliveryNotes");
        this.dueDays = Utility.getJSONInt(customerJson, "dueDays");
        this.discountDays = Utility.getJSONInt(customerJson, "discountDays");
        this.uploaded = Utility.getJSONBoolean(customerJson, "uploaded");
        this.isComoCustomer = Utility.getJSONBoolean(customerJson, "isComoCustomer");
        this.accountingRef = Utility.getJSONString(customerJson, "AccountingRef");
        this.resaleNo = Utility.getJSONString(customerJson, "resaleNo");
        this.isActive = Utility.getJSONBoolean(customerJson, "isActive");
    }

    public Customer(JSONObject json) {
        try {
            this.isActive = json.getBoolean("isActive");
            this.code = json.getString("id");
            this.code = Utility.translateSpecial(this.code);
            this.companyName = json.getString("companyName");
            this.first = json.getString("first");
            this.middle = json.getString("middle");
            this.last = json.getString("last");
            this.address1 = json.getString("address1");
            this.address2 = json.getString("address2");
            this.city = json.getString("city");
            this.state = json.getString("state");
            this.zip = json.getString("zip");
            this.country = json.getString("country");
            this.contact = json.getString("contact");
            this.taxable = json.getBoolean("taxable");
            this.email = json.getString("email");
            this.phone = json.getString("phone");
            this.fax = json.getString("fax");
            this.terms = json.getString("terms");
            this.type = json.getString("type");
            this.priceLevel = json.getInt("priceLevel");
            this.creditLimit = json.getDouble("creditLimit");
            this.balance = json.getDouble("balance");
            this.loyaltyBalance = json.getDouble("loyaltyBalance");
            this.discountItemId = json.getString("discountItemId");
            this.discountPercent = json.getDouble("discount");
            this.taxCode = json.getString("taxCode");
            this.note = json.getString("notes");
            this.deliveryNotes = json.getString("deliveryNotes");
            this.dueDays = json.getInt("dueDays");
            this.discountDays = json.getInt("discountDays");
            this.uploaded = json.getBoolean("uploaded");
            this.isComoCustomer = json.getBoolean("isComoCustomer");
            this.accountingRef = json.getString("accountingRef");
            this.resaleNo = json.getString("resaleNo");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("isActive", this.isActive);
            jsonObject.put("id", (Object)this.code);
            jsonObject.put("companyName", (Object)this.companyName);
            jsonObject.put("first", (Object)this.first);
            jsonObject.put("middle", (Object)this.middle);
            jsonObject.put("last", (Object)this.last);
            jsonObject.put("address1", (Object)this.address1);
            jsonObject.put("address2", (Object)this.address2);
            jsonObject.put("city", (Object)this.city);
            jsonObject.put("state", (Object)this.state);
            jsonObject.put("zip", (Object)this.zip);
            jsonObject.put("country", (Object)this.country);
            jsonObject.put("contact", (Object)this.contact);
            jsonObject.put("taxable", this.taxable);
            jsonObject.put("email", (Object)this.email);
            jsonObject.put("phone", (Object)this.phone);
            jsonObject.put("fax", (Object)this.fax);
            jsonObject.put("terms", (Object)this.terms);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("priceLevel", this.priceLevel);
            jsonObject.put("creditLimit", this.creditLimit);
            jsonObject.put("balance", this.balance);
            jsonObject.put("loyaltyBalance", this.loyaltyBalance);
            jsonObject.put("discountItemId", (Object)this.discountItemId);
            jsonObject.put("discount", this.discountPercent);
            jsonObject.put("taxCode", (Object)this.taxCode);
            jsonObject.put("notes", (Object)this.note);
            jsonObject.put("deliveryNotes", (Object)this.deliveryNotes);
            jsonObject.put("dueDays", this.dueDays);
            jsonObject.put("discountDays", this.discountDays);
            jsonObject.put("uploaded", this.uploaded);
            jsonObject.put("isComoCustomer", this.isComoCustomer);
            jsonObject.put("accountingRef", (Object)this.accountingRef);
            jsonObject.put("resaleNo", (Object)this.resaleNo);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

