/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerTerm {
    public int id = 0;
    public int discountDays = 0;
    public double discountPercent = 0.0;
    public String terms = "";
    public int daysUntilDue = 0;
    public int dueDayOfMonth = 0;
    public boolean noSync = false;
    public Timestamp lastChanged;

    public CustomerTerm(int id, int discountDays, double discountPercent, String terms, int daysUntilDue) {
        this.id = id;
        this.discountDays = discountDays;
        this.discountPercent = discountPercent;
        this.terms = terms;
        this.daysUntilDue = daysUntilDue;
    }

    public CustomerTerm(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.discountDays = Utility.getIntElement("DiscountDays", xml);
        this.discountPercent = Utility.getDoubleElement("DiscountPercent", xml);
        this.terms = Utility.getElement("Terms", xml);
        this.daysUntilDue = Utility.getIntElement("DaysUntilDue", xml);
        this.dueDayOfMonth = Utility.getIntElement("DueDayOfMonth", xml);
        this.noSync = Utility.getBooleanElement("NoSync", xml);
        long lastChangedValue = Utility.getLongElement("LastChanged", xml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<CustomerTerm>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<DiscountDays>" + this.discountDays + "</DiscountDays>");
        xml.append("<DiscountPercent>" + this.discountPercent + "</DiscountPercent>");
        xml.append("<Terms>" + this.terms + "</Terms>");
        xml.append("<DaysUntilDue>" + this.daysUntilDue + "</DaysUntilDue>");
        xml.append("<DueDayOfMonth>" + this.dueDayOfMonth + "</DueDayOfMonth>");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        xml.append("</NoPartialQuantity>\n");
        xml.append("</CustomerTerm>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("discountDays", this.discountDays);
            jsonObject.put("discountPercent", this.discountPercent);
            jsonObject.put("terms", (Object)this.terms);
            jsonObject.put("daysUntilDue", this.daysUntilDue);
            jsonObject.put("dueDayOfMonth", this.dueDayOfMonth);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public CustomerTerm(JSONString jsonString) {
        String customerJson = jsonString.toString();
        this.id = Utility.getJSONInt(customerJson, "id");
        this.discountDays = Utility.getJSONInt(jsonString.toString(), "discountDays");
        this.discountPercent = Utility.getJSONInt(customerJson, "discountPercent");
        this.terms = Utility.getJSONString(customerJson, "terms");
        this.daysUntilDue = Utility.getJSONInt(customerJson, "daysUntilDue");
        this.dueDayOfMonth = Utility.getJSONInt(customerJson, "dueDayOfMonth");
    }
}

