/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

public class DisplayItem
implements Serializable {
    public String itemCode = "";
    public String description = "";
    public String itemType = "";
    public ArrayList choices = null;
    public float quantity = 0.0f;
    public boolean displayed = false;
    public boolean carryOut = false;
    public boolean isAppetizer = false;
    public String seat = "";
    public long key = 0L;
    public String userGroup = "";
    public String processStatus = "";
    public boolean doNotPrint = false;
    public String lineStatus = "";
    public boolean isChoice = false;
    public String courseName = "";
    public boolean displayOnRemote = false;

    public DisplayItem() {
    }

    public DisplayItem(String xItemCode, String xDescription, float xQuantity, String xItemType) {
        this.description = xDescription;
        this.itemType = xItemType;
        this.itemCode = xItemCode;
        this.quantity = xQuantity;
        this.choices = new ArrayList();
    }

    public void setCarryOut() {
        this.carryOut = true;
    }

    public void addChoice(String xChoice) {
        String lines = xChoice;
        String cr = "\r\n";
        while (lines.length() > 0) {
            String thisLine;
            int end = lines.indexOf(cr);
            if (end > 0) {
                thisLine = lines.substring(0, end);
                lines = lines.substring(end + 2);
            } else {
                thisLine = lines;
                lines = "";
            }
            this.choices.add(thisLine);
        }
    }

    public String toXml() {
        StringBuilder itemXml = new StringBuilder();
        itemXml.append("<Item>\r\n");
        itemXml.append("  <Code>" + this.itemCode + "</Code>\r\n");
        itemXml.append("  <Description>" + this.description + "</Description>\r\n");
        itemXml.append("  <ItemType>" + this.itemType + "</ItemType>\r\n");
        itemXml.append("  <Quantity>" + this.quantity + "</Quantity>\r\n");
        itemXml.append("  <Displayed>" + this.displayed + "</Displayed>\r\n");
        itemXml.append("  <CarryOut>" + this.carryOut + "</CarryOut>\r\n");
        itemXml.append("  <IsAppetizer>" + this.isAppetizer + "</IsAppetizer>\r\n");
        itemXml.append("  <Seat>" + this.seat + "</Seat>\r\n");
        itemXml.append("  <Key>" + this.key + "</Key>\r\n");
        itemXml.append("  <UserGroup>" + this.userGroup + "</UserGroup>\r\n");
        StringBuilder choicesXml = new StringBuilder();
        if (this.choices != null && !this.choices.isEmpty()) {
            int len = this.choices.size();
            for (int i = 0; i < len; ++i) {
                String thisChoice = (String)this.choices.get(i);
                choicesXml.append("    <Choice>" + thisChoice + "</Choice>\r\n");
            }
        }
        itemXml.append("  <Choices>\r\n" + choicesXml + "  </Choices>\r\n");
        itemXml.append("<ProcessStatus>" + this.processStatus + "</ProcessStatus>\r\n");
        itemXml.append("<DoNotPrint>" + this.doNotPrint + "</DoNotPrint>\r\n");
        itemXml.append("<LineStatus>" + this.lineStatus + "</LineStatus>\r\n");
        itemXml.append("<IsChoice>" + this.isChoice + "</IsChoice>");
        itemXml.append("<CourseName>" + this.courseName + "</CourseName>");
        itemXml.append("</Item>\r\n");
        return itemXml.toString();
    }

    public DisplayItem(String xml) {
        this.itemCode = Utility.getElement("Code", xml);
        this.description = Utility.getElement("Description", xml);
        this.itemType = Utility.getElement("ItemType", xml);
        this.quantity = (float)Utility.getDoubleElement("Quantity", xml);
        this.displayed = Utility.getBooleanElement("Displayed", xml);
        this.carryOut = Utility.getBooleanElement("CarryOut", xml);
        this.isAppetizer = Utility.getBooleanElement("IsAppetizer", xml);
        this.seat = Utility.getElement("Seat", xml);
        this.key = Utility.getLongElement("Key", xml);
        this.userGroup = Utility.getElement("UserGroup", xml);
        String choicesXml = Utility.getElement("Choices", xml);
        Vector choicesList = Utility.getElementList("Choice", choicesXml);
        this.choices = new ArrayList();
        this.choices.addAll(choicesList);
        this.processStatus = Utility.getElement("ProcessStatus", xml);
        this.doNotPrint = Utility.getBooleanElement("DoNotPrint", xml);
        this.lineStatus = Utility.getElement("LineStatus", xml);
        this.isChoice = Utility.getBooleanElement("IsChoice", xml);
        this.courseName = Utility.getElement("CourseName", xml);
    }
}

