/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemGroup {
    public int id = 0;
    public String masterItem = "";
    public String detailItem = "";
    public double quantity = 0.0;
    public boolean print = false;
    public String description = "";
    public double price = 0.0;
    public int masterGroupItemKey = 0;
    public boolean addedToOrder = false;
    public boolean isChoiceItem = false;

    public ItemGroup(int id, String masterItem, String detailItem, double quantity, boolean print, double price) {
        this.id = id;
        this.masterItem = masterItem;
        this.detailItem = detailItem;
        this.quantity = quantity;
        this.print = print;
        this.price = price;
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ItemGroup>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<MasterItem>" + this.masterItem + "</MasterItem>");
        xml.append("<DetailItem>" + this.detailItem + "</DetailItem>");
        xml.append("<Quantity>" + this.quantity + "</Quantity>");
        xml.append("<Print>" + this.print + "</Print>");
        xml.append("<Price>" + this.price + "</Price>");
        xml.append("<GroupItemDescription>" + this.description + "</GroupItemDescription>");
        xml.append("</ItemGroup>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("masterItem", (Object)this.masterItem);
            jsonObject.put("detailItem", (Object)this.detailItem);
            jsonObject.put("quantity", this.quantity);
            jsonObject.put("price", this.price);
            jsonObject.put("print", this.print);
            jsonObject.put("groupItemDescription", (Object)this.description);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public ItemGroup(String groupXml) {
        this.id = Utility.getIntElement("Id", groupXml);
        this.masterItem = Utility.getElement("MasterItem", groupXml);
        this.detailItem = Utility.getElement("DetailItem", groupXml);
        this.quantity = Utility.getDoubleElement("Quantity", groupXml);
        this.price = Utility.getDoubleElement("Price", groupXml);
        this.print = Utility.getBooleanElement("Print", groupXml);
        this.description = Utility.getElement("GroupItemDescription", groupXml);
    }

    public ItemGroup(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.masterItem = Utility.getJSONString(jsonString.toString(), "masterItem");
        this.detailItem = Utility.getJSONString(jsonString.toString(), "detailItem");
        this.description = Utility.getJSONString(jsonString.toString(), "groupItemDescription");
        this.quantity = Utility.getJSONDouble(jsonString.toString(), "quantity");
        this.price = Utility.getJSONDouble(jsonString.toString(), "price");
        this.print = Utility.getJSONBoolean(jsonString.toString(), "print");
    }
}

