/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import java.text.DecimalFormat;

public class LoyaltyPointsProgram {
    public String name = "";
    public String group = "";
    public String item = "";
    public Timestamp start = null;
    public Timestamp end = null;
    public int fromMinutes = 0;
    public int thruMinutes = 0;
    public boolean sunday = false;
    public boolean monday = false;
    public boolean tuesday = false;
    public boolean wednesday = false;
    public boolean thursday = false;
    public boolean friday = false;
    public boolean saturday = false;
    public double points = 0.0;
    public boolean onQuantity = true;

    public LoyaltyPointsProgram() {
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<LoyaltyPointsProgram>");
        xml.append("<LoyaltyPointsProgramName>" + this.name + "</LoyaltyPointsProgramName>");
        xml.append("<Group>" + this.group + "</Group>");
        xml.append("<SalePriceItem>" + this.item + "</SalePriceItem>");
        xml.append("<Start>" + this.start + "</Start>");
        xml.append("<End>" + this.end + "</End>");
        xml.append("<Points>" + decimal.format(this.points) + "</Points>");
        xml.append("<FromMinutes>" + this.fromMinutes + "</FromMinutes>");
        xml.append("<ThruMinutes>" + this.thruMinutes + "</ThruMinutes>");
        xml.append("<Sunday>" + this.sunday + "</Sunday>");
        xml.append("<Monday>" + this.monday + "</Monday>");
        xml.append("<Tuesday>" + this.tuesday + "</Tuesday>");
        xml.append("<Wednesday>" + this.wednesday + "</Wednesday>");
        xml.append("<Thursday>" + this.thursday + "</Thursday>");
        xml.append("<Friday>" + this.friday + "</Friday>");
        xml.append("<Saturday>" + this.saturday + "</Saturday>");
        xml.append("<OnQuantity>" + this.onQuantity + "</OnQuantity>");
        xml.append("</LoyaltyPointsProgram>");
        return xml.toString();
    }

    public LoyaltyPointsProgram(String xml) {
        this.name = Utility.getElement("LoyaltyPointsProgramName", xml);
        this.group = Utility.getElement("Group", xml);
        this.item = Utility.getElement("SalePriceItem", xml);
        String startTime = Utility.getElement("Start", xml);
        this.start = !startTime.equals("null") ? Timestamp.valueOf(startTime) : null;
        String endTime = Utility.getElement("End", xml);
        this.end = !endTime.equals("null") ? Timestamp.valueOf(endTime) : null;
        this.points = Utility.getDoubleElement("Points", xml);
        this.onQuantity = Utility.getBooleanElement("OnQuantity", xml);
        this.fromMinutes = Utility.getIntElement("FromMinutes", xml);
        this.thruMinutes = Utility.getIntElement("ThruMinutes", xml);
        this.sunday = Utility.getBooleanElement("Sunday", xml);
        this.monday = Utility.getBooleanElement("Monday", xml);
        this.tuesday = Utility.getBooleanElement("Tuesday", xml);
        this.wednesday = Utility.getBooleanElement("Wednesday", xml);
        this.thursday = Utility.getBooleanElement("Thursday", xml);
        this.friday = Utility.getBooleanElement("Friday", xml);
        this.saturday = Utility.getBooleanElement("Saturday", xml);
    }
}

