/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class PriceLevelTime {
    public int id = 0;
    public String priceLevel = "";
    public boolean sunday = false;
    public boolean monday = false;
    public boolean tuesday = false;
    public boolean wednesday = false;
    public boolean thursday = false;
    public boolean friday = false;
    public boolean saturday = false;
    public long priceStart = 0L;
    public long priceEnd = 0L;
    public boolean noSync = false;
    public Timestamp lastChanged;

    public PriceLevelTime(int id, String priceLevel, boolean sunday, boolean monday, boolean tuesday, boolean wednesday, boolean thursday, boolean friday, boolean saturday, long priceStart, long priceEnd) {
        this.id = id;
        this.priceLevel = priceLevel;
        this.sunday = sunday;
        this.monday = monday;
        this.tuesday = tuesday;
        this.wednesday = wednesday;
        this.thursday = thursday;
        this.friday = friday;
        this.saturday = saturday;
        this.priceStart = priceStart;
        this.priceEnd = priceEnd;
    }

    public PriceLevelTime(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.priceLevel = Utility.getElement("PriceLevel", xml);
        this.sunday = Utility.getBooleanElement("Sunday", xml);
        this.monday = Utility.getBooleanElement("Monday", xml);
        this.tuesday = Utility.getBooleanElement("Tuesday", xml);
        this.wednesday = Utility.getBooleanElement("Wednesday", xml);
        this.thursday = Utility.getBooleanElement("Thursday", xml);
        this.friday = Utility.getBooleanElement("Friday", xml);
        this.saturday = Utility.getBooleanElement("Saturday", xml);
        this.priceStart = Utility.getLongElement("PriceStart", xml);
        this.priceEnd = Utility.getLongElement("PriceEnd", xml);
        this.noSync = Utility.getBooleanElement("NoSync", xml);
        long lastChangedValue = Utility.getLongElement("LastChanged", xml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<PriceLevelTime>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<PriceLevel>" + this.priceLevel + "</PriceLevel>");
        xml.append("<Sunday>" + this.sunday + "</Sunday>");
        xml.append("<Monday>" + this.monday + "</Monday>");
        xml.append("<Tuesday>" + this.tuesday + "</Tuesday>");
        xml.append("<Wednesday>" + this.wednesday + "</Wednesday>");
        xml.append("<Thursday>" + this.thursday + "</Thursday>");
        xml.append("<Friday>" + this.friday + "</Friday>");
        xml.append("<Saturday>" + this.saturday + "</Saturday>");
        xml.append("<PriceStart>" + this.priceStart + "</PriceStart>");
        xml.append("<PriceEnd>" + this.priceEnd + "</PriceEnd>");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        xml.append("</NoPartialQuantity>\n");
        xml.append("</PriceLevelTime>");
        return xml.toString();
    }

    public JSONObject toJson() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("priceLevel", (Object)this.priceLevel);
            jsonObject.put("sunday", this.sunday);
            jsonObject.put("monday", this.monday);
            jsonObject.put("tuesday", this.tuesday);
            jsonObject.put("wednesday", this.wednesday);
            jsonObject.put("thursday", this.thursday);
            jsonObject.put("friday", this.friday);
            jsonObject.put("saturday", this.saturday);
            jsonObject.put("priceStart", (Object)timeFormat.format(this.priceStart));
            jsonObject.put("priceEnd", (Object)timeFormat.format(this.priceEnd));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public PriceLevelTime(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.priceLevel = Utility.getJSONString(jsonString.toString(), "priceLevel");
        this.sunday = Utility.getJSONBoolean(jsonString.toString(), "sunday");
        this.monday = Utility.getJSONBoolean(jsonString.toString(), "monday");
        this.tuesday = Utility.getJSONBoolean(jsonString.toString(), "tuesday");
        this.wednesday = Utility.getJSONBoolean(jsonString.toString(), "wednesday");
        this.thursday = Utility.getJSONBoolean(jsonString.toString(), "thursday");
        this.friday = Utility.getJSONBoolean(jsonString.toString(), "friday");
        this.saturday = Utility.getJSONBoolean(jsonString.toString(), "saturday");
        this.priceStart = Utility.getJSONLong(jsonString.toString(), "priceStart");
        this.priceEnd = Utility.getJSONLong(jsonString.toString(), "priceEnd");
    }
}

