/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;

public class QBOAuth {
    public String realmId = "";
    public String accessToken = "";
    public String refreshToken = "";
    public long accessCreated;
    public long refreshCreated;
    public String clientId = "";
    public String clientSecret = "";
    public boolean usingSandbox = false;
    public String applicationKey = "";

    public QBOAuth() {
    }

    public QBOAuth(String xml) {
        this.accessToken = Utility.getElement("AccessToken", xml);
        this.refreshToken = Utility.getElement("RefreshToken", xml);
        this.accessCreated = Utility.getLongElement("AccessCreated", xml);
        this.refreshCreated = Utility.getLongElement("RefreshCreated", xml);
        this.realmId = Utility.getElement("RealmId", xml);
        this.applicationKey = Utility.getElement("ApplicationKey", xml);
        if (!this.applicationKey.isEmpty()) {
            if (this.applicationKey.compareToIgnoreCase("SandBox") == 0) {
                this.usingSandbox = true;
            } else if (this.applicationKey.compareToIgnoreCase("KeeferSandBox") == 0) {
                this.usingSandbox = true;
            }
        }
    }

    public QBOAuth(String realmId, String accessToken, String refreshToken) {
        this.realmId = realmId;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public QBOAuth Copy() {
        QBOAuth newAuth = new QBOAuth();
        newAuth.realmId = this.realmId;
        newAuth.accessToken = this.accessToken;
        newAuth.refreshToken = this.refreshToken;
        newAuth.accessCreated = this.accessCreated;
        newAuth.refreshCreated = this.refreshCreated;
        newAuth.clientId = this.clientId;
        newAuth.clientSecret = this.clientSecret;
        newAuth.applicationKey = this.applicationKey;
        newAuth.usingSandbox = this.usingSandbox;
        return newAuth;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean hasValues() {
        boolean valid = false;
        if (!(this.accessToken.isEmpty() || this.refreshToken.isEmpty() || this.realmId.isEmpty() || this.accessCreated <= 0L || this.refreshCreated <= 0L)) {
            valid = true;
        }
        return valid;
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<QBOAuth>\r\n");
        if (!(this.accessToken.isEmpty() || this.refreshToken.isEmpty() || this.realmId.isEmpty() || this.accessCreated <= 0L || this.refreshCreated <= 0L)) {
            xml.append("<AccessToken>" + this.accessToken + "</AccessToken>" + "\r\n");
            xml.append("<RefreshToken>" + this.refreshToken + "</RefreshToken>" + "\r\n");
            xml.append("<AccessCreated>" + this.accessCreated + "</AccessCreated>" + "\r\n");
            xml.append("<RefreshCreated>" + this.refreshCreated + "</RefreshCreated>" + "\r\n");
            xml.append("<RealmId>" + this.realmId + "</RealmId>" + "\r\n");
        }
        if (!this.applicationKey.isEmpty()) {
            xml.append("<ApplicationKey>" + this.applicationKey + "</ApplicationKey>" + "\r\n");
        }
        xml.append("</QBOAuth>");
        return xml.toString();
    }
}

