/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.text.DecimalFormat;
import java.util.Hashtable;
import org.json.JSONException;
import org.json.JSONObject;

public class Tender {
    public String code = "";
    public double amount = 0.0;
    public boolean newTender = true;
    public int id = 0;
    public boolean isChange = false;
    public boolean isAutoGratuity = false;
    public String description = "";
    public String approval = "";
    public String user = "";
    public String till = "";
    public int sequence = 0;
    public String reference = "";
    public String type = "";
    public String status = "";
    public String cardHolder = "";
    public int transaction = 0;
    public String cardNumber = "";
    public String cardExpiry = "";
    public String managerId = "";
    public String responseData = "";
    public String signature = "";
    public int masterId = 0;
    public long created = 0L;
    public String origin = "";
    public String glAccountNumber = "";
    public boolean cashSale = false;
    public int tenderTypeCount = 0;
    public String locationCode = "";
    public double conversionRate = 1.0;

    public Tender() {
    }

    public Tender(String code, double amount) {
        this.code = code;
        this.amount = amount;
    }

    public Tender(int id) {
        this.id = id;
    }

    public Tender(String xml) {
        if (xml.contains("<Tender>")) {
            xml = Utility.getElement("Tender", xml);
        }
        Hashtable tenderElements = Utility.getElements(xml);
        this.code = Utility.getElement("Code", tenderElements);
        this.amount = Utility.getDoubleElement("Amount", tenderElements);
        this.newTender = Utility.getBooleanElement("NewTender", tenderElements);
        this.isChange = Utility.getBooleanElement("IsChange", tenderElements);
        this.isAutoGratuity = Utility.getBooleanElement("IsAutoGratuity", tenderElements);
        this.id = Utility.getIntElement("Id", tenderElements);
        this.description = Utility.getElement("Description", tenderElements);
        this.approval = Utility.getElement("Approval", tenderElements);
        this.user = Utility.getElement("User", tenderElements);
        this.till = Utility.getElement("Till", tenderElements);
        this.sequence = Utility.getIntElement("Sequence", tenderElements);
        this.reference = Utility.getElement("Reference", tenderElements);
        this.type = Utility.getElement("Type", tenderElements);
        this.status = Utility.getElement("Status", tenderElements);
        this.cardHolder = Utility.getElement("CardHolder", tenderElements);
        this.transaction = Utility.getIntElement("TransactionNumber", tenderElements);
        this.cardNumber = Utility.getElement("CardNumber", tenderElements);
        this.cardExpiry = Utility.getElement("CardExpiry", tenderElements);
        this.tenderTypeCount = Utility.getIntElement("TenderTypeCount", tenderElements);
        this.managerId = Utility.getElement("ManagerId", tenderElements);
        this.responseData = Utility.getElement("ResponseData", xml);
        this.signature = Utility.getElement("Signature", tenderElements);
        this.masterId = Utility.getIntElement("MasterId", tenderElements);
        String createdText = Utility.getElement("TenderCreated", tenderElements);
        try {
            this.created = Long.parseLong(createdText);
        }
        catch (Exception e) {
            this.created = 0L;
        }
        this.origin = Utility.getElement("Origin", tenderElements);
        this.conversionRate = Utility.getDoubleElement("ConversionRate", tenderElements);
        this.locationCode = Utility.getElement("LocationCode", tenderElements);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");
        DecimalFormat conversionRateDecimal = new DecimalFormat("####0.000;-####0.000");
        xml.append("<Tender>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Amount>" + decimal.format(this.amount) + "</Amount>");
        xml.append("<NewTender>" + Boolean.toString(this.newTender) + "</NewTender>");
        xml.append("<IsChange>" + Boolean.toString(this.isChange) + "</IsChange>");
        xml.append("<IsAutoGratuity>" + Boolean.toString(this.isAutoGratuity) + "</IsAutoGratuity>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<Approval>" + this.approval + "</Approval>");
        xml.append("<User>" + this.user + "</User>");
        xml.append("<Sequence>" + this.sequence + "</Sequence>");
        xml.append("<Reference>" + this.reference + "</Reference>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<Status>" + this.status + "</Status>");
        xml.append("<CardHolder>" + this.cardHolder + "</CardHolder>");
        xml.append("<CardNumber>" + this.cardNumber + "</CardNumber>");
        xml.append("<CardExpiry>" + this.cardExpiry + "</CardExpiry>");
        xml.append("<TransactionNumber>" + this.transaction + "</TransactionNumber>");
        xml.append("<TenderTypeCount>" + this.tenderTypeCount + "</TenderTypeCount>");
        xml.append("<ManagerId>" + this.managerId + "</ManagerId>");
        xml.append("<ResponseData>" + this.responseData + "</ResponseData>");
        xml.append("<Signature>" + this.signature + "</Signature>");
        xml.append("<MasterId>" + this.masterId + "</MasterId>");
        xml.append("<TenderCreated>" + this.created + "</TenderCreated>");
        xml.append("<Origin>" + this.origin + "</Origin>");
        xml.append("<ConversionRate>" + conversionRateDecimal.format(this.conversionRate) + "</ConversionRate>");
        xml.append("<LocationCode>" + this.locationCode + "</LocationCode>");
        xml.append("</Tender>");
        return xml.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        boolean result = false;
        if (this.id != 0 && this.id == ((Tender)obj).id) {
            result = true;
        }
        if (!result && this.created != 0L && this.created == ((Tender)obj).created) {
            result = this.code.equalsIgnoreCase(((Tender)obj).code);
        }
        return result;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("location", (Object)this.locationCode);
            jsonObject.put("tenderCode", (Object)this.code);
            jsonObject.put("tenderDescription", (Object)this.description);
            jsonObject.put("amount", this.amount);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

