/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.RegionalDecimalFormat;
import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Till {
    public String name = "";
    public boolean in = false;
    public boolean z = false;
    public double startingCash = 0.0;
    public int nextSequence = 0;
    public String user = "";
    public boolean isAutoZ = false;
    public Timestamp autoZTime = null;
    public int noSaleCount = 0;
    public String station = "";
    public int drawerNumber = 1;
    public boolean openSalesOnly = false;
    public String glDepartment = "";
    public boolean active = true;

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<Till>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<In>" + this.in + "</In>");
        xml.append("<Zout>" + this.z + "</Zout>");
        xml.append("<StartCash>" + this.startingCash + "</StartCash>");
        xml.append("<NextSeq>" + this.nextSequence + "</NextSeq>");
        xml.append("<User>" + this.user + "</User>");
        xml.append("<IsAutoZ>" + this.isAutoZ + "</IsAutoZ>");
        xml.append("<AutoZTime>" + this.autoZTime + "</AutoZTime>");
        xml.append("<NoSaleCount>" + this.noSaleCount + "</NoSaleCount>");
        xml.append("<Station>" + this.station + "</Station>");
        xml.append("<DrawerNumber>" + this.drawerNumber + "</DrawerNumber>");
        xml.append("<OpenSalesOnly>" + this.openSalesOnly + "</OpenSalesOnly>");
        xml.append("<GLDepartment>" + this.glDepartment + "</GLDepartment>");
        xml.append("<TillIsActive>" + this.active + "</TillIsActive>");
        xml.append("</Till>");
        return xml.toString();
    }

    public Till() {
    }

    public Till(String tillXml) {
        this.name = Utility.getElement("Name", tillXml);
        this.in = Utility.getBooleanElement("In", tillXml);
        this.z = Utility.getBooleanElement("Zout", tillXml);
        this.startingCash = Utility.getDoubleElement("StartCash", tillXml);
        this.nextSequence = Utility.getIntElement("NextSeq", tillXml);
        this.user = Utility.getElement("User", tillXml);
        this.isAutoZ = Utility.getBooleanElement("IsAutoZ", tillXml);
        String zTime = Utility.getElement("AutoZTime", tillXml);
        this.autoZTime = zTime.equals("null") || zTime.isEmpty() ? null : Timestamp.valueOf(zTime);
        this.noSaleCount = Utility.getIntElement("NoSaleCount", tillXml);
        this.station = Utility.getElement("Station", tillXml);
        this.drawerNumber = Utility.getIntElement("DrawerNumber", tillXml);
        this.openSalesOnly = Utility.getBooleanElement("OpenSalesOnly", tillXml);
        this.glDepartment = Utility.getElement("GLDepartment", tillXml);
        this.active = Utility.getBooleanElement("TillIsActive", tillXml);
    }

    public Till(JSONString jsonString) {
        this.name = Utility.getJSONString(jsonString.toString(), "id");
        String cash = Utility.getJSONString(jsonString.toString(), "cash");
        try {
            RegionalDecimalFormat decF = new RegionalDecimalFormat("#.##");
            this.startingCash = decF.convertRegionalTextToDecimal(decF, cash);
        }
        catch (Exception e) {
            this.startingCash = 0.0;
        }
        this.glDepartment = Utility.getJSONString(jsonString.toString(), "glDept");
        this.openSalesOnly = Utility.getJSONBoolean(jsonString.toString(), "tenderOrders");
        boolean openDrawer2 = Utility.getJSONBoolean(jsonString.toString(), "openDrawer2");
        this.drawerNumber = openDrawer2 ? 2 : 1;
        this.isAutoZ = Utility.getJSONBoolean(jsonString.toString(), "autoZ");
        this.autoZTime = null;
        String zOutTime = Utility.getJSONString(jsonString.toString(), "zOutTime");
        try {
            SimpleDateFormat df = new SimpleDateFormat("hh:mm a");
            Date parsedDate = df.parse(zOutTime);
            this.autoZTime = new Timestamp(parsedDate.getTime());
        }
        catch (Exception e) {
            this.autoZTime = null;
        }
        this.active = Utility.getJSONBoolean(jsonString.toString(), "tillIsActive");
    }

    public JSONObject toJson() {
        String autoZTimeString = this.autoZTime != null ? new SimpleDateFormat("hh:mm a").format(this.autoZTime) : "";
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.name);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("cash", this.startingCash);
            jsonObject.put("glDept", (Object)this.glDepartment);
            jsonObject.put("tenderOrders", this.openSalesOnly);
            jsonObject.put("openDrawer2", this.drawerNumber == 2);
            jsonObject.put("zOutTime", (Object)autoZTimeString);
            jsonObject.put("autoZ", this.isAutoZ);
            jsonObject.put("tillIsActive", this.active);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public String toString() {
        return this.name;
    }
}

