/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class User {
    public String id = "";
    public String password = "";
    public String userName = "";
    public String group = "";
    public long access = 0L;
    public String till = "";
    public int logOutTime = 0;
    public boolean singleTill = false;
    public int serverId = 0;
    public boolean selectedFlag = false;
    public boolean isServer = false;
    public int openOrderCount = 0;
    public String token = "";
    public String employeeId = "";
    public boolean isDriver = false;
    public int loginAttempts = 0;

    public User(String id, String password, String group, long access, String till) {
        this.id = id;
        this.password = password;
        this.group = group;
        this.access = access;
        this.till = till;
    }

    public User(String id, String password, String group, long access, String till, int logOutTime, boolean singleTill, int serverId, boolean isServer) {
        this.id = id;
        this.password = password;
        this.group = group;
        this.access = access;
        this.till = till;
        this.logOutTime = logOutTime;
        this.singleTill = singleTill;
        this.serverId = serverId;
        this.isServer = isServer;
        this.openOrderCount = 0;
    }

    public User(String id, String password, String group, long access, String till, int logOutTime, boolean singleTill, int serverId, boolean isServer, int openOrderCount) {
        this.id = id;
        this.password = password;
        this.group = group;
        this.access = access;
        this.till = till;
        this.logOutTime = logOutTime;
        this.singleTill = singleTill;
        this.serverId = serverId;
        this.isServer = isServer;
        this.openOrderCount = openOrderCount;
    }

    public User(String thisUserXml) {
        this.id = Utility.getElement("Id", thisUserXml);
        this.password = Utility.getElement("Passcode", thisUserXml);
        this.userName = Utility.getElement("UserName", thisUserXml);
        this.group = Utility.getElement("Group", thisUserXml);
        this.access = Utility.getLongElement("Access", thisUserXml);
        this.till = Utility.getElement("Till", thisUserXml);
        this.logOutTime = Utility.getIntElement("LogOutTime", thisUserXml);
        this.singleTill = Utility.getBooleanElement("SingleTill", thisUserXml);
        this.serverId = Utility.getIntElement("ServerId", thisUserXml);
        this.isServer = Utility.getBooleanElement("IsServer", thisUserXml);
        this.openOrderCount = Utility.getIntElement("OpenOrderCount", thisUserXml);
        this.token = Utility.getElement("SessionToken", thisUserXml);
        this.employeeId = Utility.getElement("EmployeeId", thisUserXml);
        this.isDriver = Utility.getBooleanElement("IsDriver", thisUserXml);
    }

    public User(JSONString jsonString) {
        this.id = Utility.getJSONString(jsonString.toString(), "posUserId");
        this.password = Utility.getJSONString(jsonString.toString(), "passcode");
        this.userName = Utility.getJSONString(jsonString.toString(), "userName");
        this.group = Utility.getJSONString(jsonString.toString(), "group");
        this.access = Utility.getJSONLong(jsonString.toString(), "access");
        this.till = Utility.getJSONString(jsonString.toString(), "till");
        this.logOutTime = Utility.getJSONInt(jsonString.toString(), "logOutTime");
        this.singleTill = Utility.getJSONBoolean(jsonString.toString(), "singleTill");
        this.serverId = Utility.getJSONInt(jsonString.toString(), "serverId");
        this.isServer = Utility.getJSONBoolean(jsonString.toString(), "isServer");
        this.openOrderCount = Utility.getJSONInt(jsonString.toString(), "openOrderCount");
        this.token = Utility.getJSONString(jsonString.toString(), "token");
        this.employeeId = Utility.getJSONString(jsonString.toString(), "employeeId");
        this.isDriver = Utility.getJSONBoolean(jsonString.toString(), "isDriver");
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            return this.password.compareTo(((User)obj).password) == 0;
        }
        return false;
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<User>\r\n");
        xml.append("   <Id>" + this.id + "</Id>\r\n");
        xml.append("   <Passcode>" + this.password + "</Passcode>\r\n");
        xml.append("   <UserName>" + this.userName + "</UserName>\r\n");
        xml.append("   <Group>" + this.group + "</Group>\r\n");
        xml.append("   <Access>" + this.access + "</Access>\r\n");
        xml.append("   <Till>" + this.till + "</Till>\r\n");
        xml.append("   <LogOutTime>" + this.logOutTime + "</LogOutTime>\r\n");
        xml.append("   <SingleTill>" + this.singleTill + "</SingleTill>\r\n");
        xml.append("   <ServerId>" + this.serverId + "</ServerId>\r\n");
        xml.append("   <IsServer>" + this.isServer + "</IsServer>\r\n");
        xml.append("   <OpenOrderCount>" + this.openOrderCount + "</OpenOrderCount>\r\n");
        if (!this.token.isEmpty()) {
            xml.append("   <SessionToken>" + this.token + "</SessionToken>\r\n");
        }
        xml.append("   <EmployeeId>" + this.employeeId + "</EmployeeId>\r\n");
        xml.append("   <IsDriver>" + this.isDriver + "</IsDriver>\r\n");
        xml.append("</User>\r\n");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.id);
            jsonObject.put("passcode", (Object)this.password);
            jsonObject.put("userName", (Object)this.userName);
            jsonObject.put("serverId", this.serverId);
            jsonObject.put("group", (Object)this.group);
            jsonObject.put("till", (Object)this.till);
            jsonObject.put("isServer", this.isServer);
            jsonObject.put("isDriver", this.isDriver);
            jsonObject.put("logOutTime", this.logOutTime);
            jsonObject.put("openOrderCount", this.openOrderCount);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public long getAccess() {
        return this.access;
    }
}

