var InventoryView = Backbone.View.extend({
    fullCollection: {},
    formModal: null,
    deletionModal: {},
    itemsAutocomplete: {},
    editedCollecton: {},
    hasAccess: false,
    sentItems: 0,
   
    prefillState: false,

    paymentTypeMapping: {},

    events: {
        'click .card-panel-entity': 'highlightCard',
        'click .edit-inventory-trigger': 'editInventory',
        'click .save-button': 'saveInventory',
        'click .delete-button': 'deletionModal',
        'click #delete-inventory-confirm': 'deleteInventory',
        'keyup #itemSearch': 'searchItemBySearchTerm',
        'click .add-item': 'addInventory',
        'click .update-inventory' : 'updateInventory',
        'keyup #qtyReceived' : 'validateForm',
        'click .close-inventory' : 'updateInventory'
    },

    breadcrumb: {},

    styles: [
        'ap-blue',
        '#31619e'
    ],

    inventoryStyleMapping: {},

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.inventoryFormTemplate = options.inventoryFormTemplate; 
        this.breadcrumb = options.breadcrumb;
        this.collection = options.collection;
        this.listenTo(this.collection, 'reset', this.render);
        this.listenTo(this.collection, 'remove', this.render);
        this.listenTo(this.collection, 'add', this.render);
        this.model = options.model;
        this.initInventory();
    },

    render: function () {
        var that = this;
        this.$el.html(this.template({
            inventory: this.collection.toJSON(),
        }));

        
        var that = this;
        App.breadCrumbToolTip = "Increase inventory quantites of items you recieve";
        
        $(document).ready(function(){
            $('.modal').modal();
            that.itemMapping = {};
            that.itemQtyMapping = {}
            that.itemCostMapping = {};
            that.itemMapping2 = {};
            document.getElementById('itemSearch').focus();
        });
            
        App.setBreadcrumbs(this.breadcrumb);

        $(document).on('keydown', 'input, select', function(e) {
            var self = $(this)
              , form = self.parents('form:eq(0)')
              , focusable
              , next
              ;
            if (e.keyCode == 13) {
                that.$el.find(".save-button").trigger("click");
                return false;
            }
        });

        $('.tooltipped').tooltip();
        this.formModal = this.$el.find('#inventory-form-modal').modal();
        return this;
    },

    searchItemBySearchTerm: function(element) {
        if (element.keyCode == 13) {
            this.$el.find(".add-item").trigger("click");
        }
        else {
            var element = $(element.currentTarget);
            var searchTerm = $(element).val();
            var that = this;
            if (searchTerm.trim().length > 0) {
                if (this.timer) {
                    clearTimeout(this.timer);
                }
                this.timer = setTimeout(function() { 
                    that.getItemsBySearchTerm(searchTerm); 
                }, 400);
            }
            // that.$el.find("input.autocomplete").trigger("click");
        }
    },

    selectItemFromAutocompleteList: function (selection) {
        var that = this;
        var element = $(selection.currentTarget);

        var itemId = document.getElementById('itemSearch');

        Object.size = function(obj) {
            var size = 0, key;
            for (key in obj) {
                if (obj.hasOwnProperty(key)) size++;
            }
            return size;
        };

        for (var i = 0; i < Object.size(that.itemMapping); i++) {
            if (Object.entries(that.itemMapping)[i][0] == selection) {
                itemId.value = Object.entries(that.itemMapping)[i][1].id;
                that.itemSelected = true;
            }
        }
    },

    getItemsBySearchTerm: function(searchTerm) {
        var that = this;
        var sessionToken = this.getCookie();
        // that.$el.find("input.autocomplete").trigger("click");

        var elems = document.querySelector('#itemSearch');
        that.itemsAutocomplete = M.Autocomplete.init(elems, {
            minLength: 1,
            sortFunction: function (a, b, inputString) {
                return a.indexOf(inputString) - b.indexOf(inputString);
            }, 
            onAutocomplete: function (selection) { that.selectItemFromAutocompleteList(selection); }
        });
        $.ajax({
            url: '/data/get-items-by-search-term',
            data: {
                searchTerm: searchTerm,
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                var results = data.results;
                that.items = {};
                var itemCodes = results.length;
                for (var i = 0; i < results.length; i++) {
                    if (results[i].isStock) {
                        var autocompleteDisplayItem = results[i].itemDescription + ' / ' + results[i].itemType + ' / ' + results[i].itemCategory + ' / ' + results[i].itemCode ;
                        that.items[autocompleteDisplayItem] = null;
                        that.itemMapping[autocompleteDisplayItem] = { description: results[i].itemDescription, id: results[i].itemCode };
                        that.itemMapping2[results[i].itemCode] = results[i].itemDescription;
                        that.itemQtyMapping[results[i].itemCode] = results[i].onHand;
                        that.itemCostMapping[results[i].itemCode] = results[i].cost;
                    }
                }
                

                that.itemsAutocomplete.updateData(that.items);
                that.itemsAutocomplete.open();
                // that.$el.find("input.autocomplete").trigger("click");  
            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    
                }
            }
        });
    },

    editInventory: function (e) {
        var element = $(e.currentTarget);
        var id = $(element).attr('data-id');
        
        if (this.collection.get(id) !== null && this.collection.get(id) !== '') {
            this.inventoryFormView = new InventoryFormView({
                template: this.inventoryFormTemplate,
                model: this.collection.get(id),
            });

            this.$el.find('#inventory-form-modal').html(this.inventoryFormView.render().el);
            this.formModal.modal('open');
        }
        else {
            M.toast({ html: '{Literal}There was a problem fetching data from the server{/Literal}' });
        }
    },

    getItemById: async function(itemId) {
        var that = this;
        var sessionToken = this.getCookie();
        try {
            return await $.ajax({
                url: '/data/get-item-by-id',
                data: {
                    token: sessionToken,
                    itemId: itemId,
                },
                dataType: 'json',
                type: 'POST',
                success: function (data) {
                    return data;
                },
                error: function (e) {
                    if (e.status == 523) {
                        window.location.href = "#/log-in";
                        location.reload();
                    }
                    else {
                        that.thisItem = undefined;
                    }
                }
            });
        }
        catch (exception)  {

        }
    },

    addInventory: async function (e) {
        
        if (this.hasAccess) {
            if(!this.itemSelected) {
                var itemCode = document.getElementById('itemSearch').value;
                var itemResult = await this.getItemById(itemCode);
                if(itemResult.results.length == 0 || !itemResult.results[0].isStock) {   
                    document.getElementById('itemSearch').value = '';
                    M.toast({ html: '{Literal}Invalid item{/Literal}' });
                    return;
                }
            }
            var searchValue = $('#itemSearch').val();
            this.itemSelected = false;
            document.getElementById('itemSearch').value = '';
            var onlyAddValid = true;

            if (searchValue === '') {
                M.toast({ html: '{Literal}Please enter an item to search{/Literal}' });
            }
            else if (onlyAddValid == false) {
                M.toast({ html: '{Literal}Please enter a valid inventory item{/Literal}' });
            }
            else if (onlyAddValid) {
                var inventory = new Inventory();
                this.inventoryFormView = new InventoryFormView({
                    template: this.inventoryFormTemplate,
                    model: inventory
                });
        
                this.$el.find('#inventory-form-modal').html(this.inventoryFormView.render().el);
                this.$el.find('select').formSelect();
                this.$el.find("select[required]").css({
                    display: "block", 
                    position: 'absolute',
                    visibility: 'hidden'
                });  
                this.formModal.modal('open');
                
                if (this.itemMapping2[searchValue] !== undefined) {
                    var id = document.getElementById('id');
                    id.value =  searchValue;

                    var qty = document.getElementById('qtyOnHand');
                    qty.value = this.itemQtyMapping[searchValue];

                    var description = document.getElementById('description');
                    description.value = this.itemMapping2[searchValue];

                    var cost = document.getElementById('cost');
                    cost.value = this.itemCostMapping[searchValue];
                }
                else {
                    var foundItem = itemResult.results[0];
                    var id = document.getElementById('id');
                    id.value =  foundItem.id;
    
                    var qty = document.getElementById('qtyOnHand');
                    qty.value = foundItem.onHand;
    
                    var description = document.getElementById('description');
                    description.value = foundItem.description;
                    
                    var cost = document.getElementById('cost');
                    cost.value = foundItem.cost;
                }
            }
        }
        else {
            M.toast({ html: '{Literal}You do not have access to Receive Inventory{/Literal}' });
        }
    },

    highlightCard: function (e) {
        this.$el.find('.edit').hide();
        this.$el.find('.card-panel-entity').removeClass('active');
        var element = $(e.currentTarget);
        var selected = $(element).attr('data-selected') === '1';
        
        if (selected) {
            $(element).removeAttr('data-selected');
            $(element).removeClass('active');
            $(element).find('.edit').hide();
        } else {
            $(element).removeAttr('data-selected');
            $(element).attr('data-selected', '1');
            $(element).find('.edit').show();
            $(element).addClass('active');
        }
    },

    initInventory: function () {
        this.checkAccess();
        this.getInventory();
    },

    checkAccess: function () {
        var that = this;
        var sessionToken = this.getCookie();
        $.ajax({
            url: '/data/check-access',
            data: {
                accessName: (App.IDS_RECEIVE_INVENTORY),
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',

            success: function (data) {
                that.hasAccess = true;
            },

            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else if (e.responseJSON.hasAccess == false) {
                    that.hasAccess = false;
                }
            }
        });
    },
    
    getCookie: function() {
        var nameEQ = "sessionCookie" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    },

    getInventory: function () {
        var that = this;
        var sessionToken = this.getCookie();
        $.ajax({
            url: '/data/create-receiving-session',
            data: {
                token: sessionToken
            },
            dataType: 'json',
            type: 'POST',
            success: function (data) {
                if(data.success){
                    that.generateInventoryStyleMapping(data.items);
                    that.renderInventory(data.items);
                }
            },
            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({
                        html: '{Literal}There was a problem fetching data from the server{/Literal}'
                    });
                }
            }
        });
    },

    renderInventory: function (data) {
        var that = this;
        data.sort(function (a, b) {
            return a.code.toLowerCase() < b.code.toLowerCase() ? -1 : (a.code.toLowerCase() > b.code.toLowerCase() ? 1 : 0);
        });
        var collection = new InventoryCollection();
        for (var i = 0; i < data.length; i++) {
            var currentInventory = {};
            currentInventory.id = data[i].code;
            currentInventory.description = data[i].item.description;
            currentInventory.total = data[i].item.onHand + data[i].count;
            currentInventory.qtyOnHand = data[i].item.onHand;
            currentInventory.cost = data[i].cost;
            currentInventory.qtyReceived = data[i].count;
            currentInventory.cardStyleClass = that.inventoryStyleMapping[data[i].code];
            
            collection.add(new Inventory(currentInventory));
        }
        that.fullCollection = collection;
        that.collection.reset(collection.models);
    },

    generateInventoryStyleMapping: function (data) {
        var inventory = [];
        var totalStyles = this.styles.length;
        var currentStyle = 0;
        for (var i = 0; i < data.length; i++) {
            if (inventory.indexOf(data[i].code) < 0) {
                inventory.push(data[i].code);
                this.inventoryStyleMapping[data[i].code] = this.styles[currentStyle];
                if (currentStyle < totalStyles - 1) {
                    currentStyle++;
                } else {
                    currentStyle = 0;
                }
            }
        }
    },

    getFormValues: function () {
        var id = this.inventoryFormView.$el.find('#id').val();
        var description = this.inventoryFormView.$el.find('#description').val();
        var qtyOnHand = this.inventoryFormView.$el.find('#qtyOnHand').val();
        var total = this.inventoryFormView.$el.find('#total').val();
        var cost = this.inventoryFormView.$el.find('#cost').val();
        
        var updatedModel = {
            id: id,
            description: description,
            qtyOnHand: qtyOnHand,
            total: total,
            cost: cost
        };
        this.editedCollecton = new InventoryCollection();
        this.inventoryFormView.model.set(updatedModel);
        this.editedCollecton.add(this.inventoryFormView.model); 
    },

    validateForm: function () {
        var valid = true;

        var validateQtyReceived = this.$el.find("#qtyReceived").val();
        if (validateQtyReceived.trim().length < 1) {
            this.$el.find("#qtyReceived").addClass("invalid");
            valid = false;
        }
        else if (validateQtyReceived.indexOf("-") > -1 || validateQtyReceived.indexOf('e') > -1) {
            this.$el.find("#qtyReceived").addClass("invalid");
            valid = false;
        }
        else if (validateQtyReceived > 999999) {
            this.$el.find("#qtyReceived").addClass("invalid");
            valid = false;
        }

        return valid;
    },

    deletionModal: function (e) {
        var that = this;
        var element = $(e.currentTarget);
        var inventoryId = $(element).attr('data-id');
        $("#delete-inventory-id").val(inventoryId);
        $('#delete-inventory-modal').modal().modal('open');
    },

    deleteInventory: function(e) {
        var element = $(e.currentTarget);
        var inventoryId = $(element).attr("data-inventory-id");
        this.collection.remove(inventoryId);
        this.render();
    },

    saveInventory: function (){
        var that = this;
        var validation = this.validateForm();
        var updateCollection = that.collection;
        if (validation) {
            var sessionAddition = $('#qtyReceived').val();
            var session = document.getElementById('total');
            var qtyOnHand = document.getElementById('qtyOnHand');
    
            // var totalNonParsed = Number(session.value) + Number(sessionAddition)
            var twoDecimalTotal = Number.parseFloat(sessionAddition).toFixed(2);
            session.value =  twoDecimalTotal;
        }

        $('#select-type-modal').modal().modal('close');

        if(validation) { 
            this.getFormValues();
            that = (that.inventoryFormView.model);
            updateCollection.add(that);

            this.render();
        }
    },

    updateInventory: async function (event) {
        var isCloseSession = false;
        if(event != undefined && event.currentTarget.classList.contains("close-inventory"))
            isCloseSession = true;
        var element = event.currentTarget;
        var inventory;
        var that = this;
        var updateCollection = that.collection;
        var sessionToken = this.getCookie();
        this.sentItems = 0;

        for (var i=0; i < that.collection.length; i++) {
             $.ajax({
                url: '/data/save-receiving-session',
                data: {
                    itemCount: that.collection.models[i].attributes.total,
                    itemCountId: (that.collection.models[i].id),
                    cost: that.collection.models[i].attributes.cost,
                    // items: JSON.stringify( { items: that.collection.toJSON() }),
                    token: sessionToken,
                },
                dataType: 'json',
                async:false,
                type: 'POST',

                success: function (data) {
                    var success = false;
                    if (typeof data.results !== 'undefined' && typeof data.results.success !== 'undefined') {
                        success = data.results.success;
                    }
                    that.sentItems++;
                    if (that.sentItems == that.collection.length) {
                        M.toast({ html: '{Literal}Inventory saved successfully{/Literal}' });
                        if(isCloseSession)
                            that.closeInventorySession();
                    }
                },

                error: function (e) {
                    if (e.status == 523) {
                        window.location.href = "#/log-in";
                        location.reload();
                    }
                    else {
                        M.toast({ html: '{Literal}There was a problem saving this inventory item{/Literal}' });
                    }
                }
            });
        }
    },

    closeInventorySession: async function () { 
        var that = this;
        var sessionToken = this.getCookie();
        // await this.updateInventory();
        $.ajax({
            url: '/data/close-receiving-session',
            data: {
                token: sessionToken,
            },
            dataType: 'json',
            type: 'POST',

            success: function (data) {
                if (data.success) {
                    M.toast({ html: '{Literal}Inventory Received successfully{/Literal}' });
                    that.collection.reset();
                    that.render();
                }
                
            },

            error: function (e) {
                if (e.status == 523) {
                    window.location.href = "#/log-in";
                    location.reload();
                }
                else {
                    M.toast({ html: '{Literal}There was a problem Receiving Inventory{/Literal}' });
                }
            }
        });
    }
});