var RemoteDisplayFormView = Backbone.View.extend({
    events: {
        'change #device-type-dropdown': 'onDeviceTypeChange'
    },

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.model = options.model;
        this.tills = options.tills;
        this.remoteDisplay = options.remoteDisplay;
        this.itemTypes = options.itemTypes;
        this.userGroups = options.userGroups;
        this.printerNames = options.printerNames;

        this.$el.html(this.template({
            remoteDisplay: this.model.toJSON(),
            itemTypes: this.itemTypes,
            tills: this.tills,
            userGroups: this.userGroups,
        }));
    },

    render: function () {
        var that = this;
        this.$el.detach();
        $(document).ready(function(){
            if (that.model.attributes.name != "" && that.model.attributes.name != undefined) {
                that.$el.find('#name').prop("disabled", true); 
            }
            else {
                that.$el.find('#name').removeAttr('disabled');
                that.onDeviceTypeChange();
            }


        });
        
        return this;
    },
    onDeviceTypeChange: function() {
        var deviceType = this.$el.find('#device-type-dropdown').val();
        $("#address").prop('disabled', false);
        $("#pageWidth").prop('disabled', false);
        $("#templateName").prop('disabled', false);
        var deviceAddress = document.getElementById('address');
        var pageWidth = document.getElementById('pageWidth');
        var templateName = document.getElementById('templateName');
 
        if (deviceType == "pax") {
            deviceAddress.value = "PAX"; 
            pageWidth.value = "570";
            templateName.value = "RemoteTicket.cfg"; 
            $("#address").prop('disabled', true);
            $("#pageWidth").prop('disabled', true);
        }
        else if(deviceType == 'ipPrinter' || deviceType == 'labelPrinter') {
            deviceAddress.value = "";
            pageWidth.value = "570"; 
            templateName.value = "RemoteTicket.cfg"; 
            // $("#address").prop('disabled', false);
            // $("#pageWidth").prop('disabled', false);
        }
        else if(deviceType == 'monitor') {
            deviceAddress.value = "";
            pageWidth.value = "0"; 
            templateName.value = ""; 
            $("#address").prop('disabled', true);
            $("#pageWidth").prop('disabled', true);
            $("#templateName").prop('disabled', true);
        }
    },
});