var RemotePrintingFormView = Backbone.View.extend({
    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.model = options.model;
        this.remotePrinting = options.remotePrinting;
        this.itemTypes = options.itemTypes;
        this.userGroups = options.userGroups;
        this.printerNames = options.printerNames;
        this.$el.html(this.template({
            remotePrinting: this.model,
            itemTypes: this.itemTypes,
            userGroups: this.userGroups,
            printerNames: this.printerNames
        }));
    },

    render: function () {
        var that = this;
        this.$el.detach();


        $(document).ready(function() {
            if (that.model.id == undefined) {
                $('#typeBlock').show();
                $('#printerBlock').show();
            }
            else {
                $('#typeBlock').hide();
                $('#printerBlock').hide();
            }
        });
        
        return this;
    }
});